import os
import pandas as pd
import wandb
import sys
import warnings
#warnings.filterwarnings("ignore")
#sys.path.append('/ADBench/')
# import the necessary package

sys.path.append('/home/ADBench')

from data_generator import DataGenerator
from myutils import Utils
import re
import gama
from gama import GamaClassifier
from gama.search_methods import RandomSearch, AsynchronousSuccessiveHalving
from pyod.models.iforest import IForest
from sklearn.decomposition import FastICA
from pyod.models.iforest import IForest
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
import ott
from pyod.models.lof import LOF
from pyod.models.ocsvm import OCSVM
from pyod.models.knn import KNN
from pyod.models.hbos import HBOS
from pyod.models.abod import ABOD
from pyod.models.loda import LODA
from pyod.models.cof import COF
from pyod.models.cblof import CBLOF
from pyod.models.cd import CD

datagenerator = DataGenerator() # data generator
utils = Utils() # utils function

anchor_dataset = "" #specify dataset here

#precomputed distance matrix for simplicity

df_  = pd.read_csv("dist02localduplicate.csv")


most_similar_dataset = df_["similar_dataset"].loc[df_["anchor_dataset"]==anchor_dataset].iloc[0]

datagenerator.dataset = anchor_dataset # specify the dataset name
anchor_data = datagenerator.generator(la=0.2, realistic_synthetic_mode="local", noise_type="duplicated_anomalies")

datagenerator.dataset = most_similar_dataset
most_similar_dataset = datagenerator.generator(la=0.2, realistic_synthetic_mode="local", noise_type="duplicated_anomalies")

g = GamaClassifier(max_total_time = 7200, max_eval_time = 2400)
g.fit(most_similar_dataset['X_train'], most_similar_dataset['y_train'])
model = g.model['0'].fit(most_similar_dataset['X_train'])
score = model.decision_function(most_similar_dataset['X_test'])
result = utils.metric(y_true=most_similar_dataset['y_test'], y_score=score)


suggested_model = model

suggested_model.fit(anchor_data['X_train'])
score = suggested_model.decision_function(anchor_data['X_test'])
result = utils.metric(y_true=anchor_data['y_test'], y_score=score)

